/*		Name:		serial.c
		Version:	0.0.12
		Date:		11/7/2001
		Serial interface for board or emulated board
*/
#include "serial.h"
#include "timeout.h"
#include <signal.h>
#include <unistd.h>
#include <stdlib.h>
#include <termios.h>
#include <fcntl.h>

#include <string.h>
#include "interface.h"
#include "fake.h"

FILE* comms_file = NULL;

void  serial_crash(void)         /* on errors crash out here*/
{
 if (SERIAL == board_type){
	tcsetattr (serial_FD, TCSANOW, &serial_originalportsettings);
	close (serial_FD);
   	}
 if (comms_file) fclose(comms_file);
 exit(1);
}

void serial_error(char *errorstring) /* on errors during setup crash here*/
{
 close (serial_FD);
 g_print ("Serial Error: %s\n", errorstring);
 exit(1);
}


int serial_setup(int waittime)      /* setup serial port settings*/
{
 struct termios serialsettings;
 struct flock lock;
 
 memset ((void *) &serialsettings, 0, sizeof (struct termios));
 serial_FD = open (portname, O_RDWR | O_NOCTTY| O_NDELAY);
 if (serial_FD < 0)
   serial_error("couldn't open serial port");
 lock.l_type = F_WRLCK;
 lock.l_whence = SEEK_SET;
 lock.l_len = 0;
 lock.l_start = 0;
 if (0 > fcntl (serial_FD, F_SETLK, &lock))
   serial_error ("failed to get serial port lock");
	fcntl (serial_FD, F_SETFL, 0);
 if (tcgetattr (serial_FD, &serial_originalportsettings) == -1)
   serial_error ("failed to set serial port attributes");
 if (cfsetispeed (&serialsettings, PORTSPEED))   /* used to be B9600 */
   serial_error ("failed to set input baud rate");
 if (cfsetospeed (&serialsettings, PORTSPEED))
   serial_error ("failed to set output baud rate");

	serialsettings.c_oflag &= ~OPOST;
	serialsettings.c_iflag |= IGNPAR;
	serialsettings.c_cflag |= CS8 | CREAD | CLOCAL;
	serialsettings.c_cc[VMIN] = 0;
	serialsettings.c_cc[VTIME] = waittime;   /* <-wait time*/

 if (tcsetattr (serial_FD, TCSADRAIN, &serialsettings))
   serial_error ("failed to update serial port attributes");

  
   
 return 1;
}



int board_getchar(unsigned char *to_get) /* get 1 char from board*/
{
 return board_getchararray(1,  to_get);
}

int board_sendchar(unsigned char to_send) /*send 1 char to the board*/
{
return board_sendchararray(1, &to_send);
}


int board_getb16(int* toget) /* get 16 bit int from board*/
{
 unsigned char from_board[2];
 if (2 != board_getchararray(2, from_board))     { board_there = 0; return 0;}
 *toget=from_board[0]+(from_board[1]<<8);
 return 2;
}

int board_sendb16(int tosend) /* send 16 bit int to the board*/
{
 if (1 != board_sendchar((unsigned char) tosend & 255))
                                                 { board_there = 0; return 0;}
 if (1 != board_sendchar((unsigned char) (tosend >> 8) & 255))
                                                 { board_there = 0; return 0;}
 return 2;
}
		   
int board_sendb32(int tosend) /* get 32 bit int from board*/
{
 int x=4;
 while(x--){
   if (1 != board_sendchar((unsigned char) tosend & 255))
                                                 { board_there = 0; return 0;}
   tosend = tosend>>8;
   }
 return 4;
}

int board_getb32(int* toget) /* send 32 bit int to the board*/
{
 int x=4;
 uchar temp;
 *toget=0;
 
for (x=0;x<4;x++){
   if (1 != board_getchar(&temp))            { board_there = 0; return 0;}
   *toget= *toget | temp<<(x*8);
   }
   
 return 4;
}

int board_getchararray(int char_number, unsigned char* data_ptr)
{
 int ret=char_number; /* get char array from the board*/
 int replycount=0;

 if (SERIAL == board_type ||
     EMULATOR == board_type ||
     NETWORK == board_type ||
     PIPE == board_type ){
	while (char_number){
		if(! fd_ready (read_pipe, 1, 500))
		{ if(VERBOSE|SERIAL_DEBUG) g_print("timeout2 got %d of %d\n",ret-char_number,ret);return ret-char_number;}
        replycount = read(read_pipe, data_ptr, char_number);
		if (!replycount)  { if(VERBOSE|SERIAL_DEBUG) g_print("timeout got %d of %d\n",ret-char_number,ret);return ret-char_number;}
		if (replycount<0) replycount=0;
		char_number -= replycount;
        if (SERIAL_DEBUG) while (replycount--) {g_print ("reply:%x\n",*data_ptr); data_ptr++;}
        else              data_ptr += replycount;
		}
	}
 if (FAKE == board_type){
    replycount = fake_getchararray (char_number,data_ptr);
    ret = replycount;
    if (SERIAL_DEBUG) while (replycount--) {g_print ("reply:%x\n",*data_ptr); data_ptr++;}
    }

	
 return ret;
}

int board_sendchararray(int char_number, unsigned char* data_ptr)
{
 int temp=0;
 if (SERIAL_DEBUG) while(temp<char_number)  g_print ("sent:%x\n",data_ptr[temp++]);
 temp=0;
 if (comms_file)   while(temp<char_number)  fprintf(comms_file, "%c", data_ptr[temp++]);

 
 if (SERIAL == board_type ||
     EMULATOR == board_type ||
     NETWORK == board_type ||
     PIPE == board_type  ) {
//        while(! fd_ready (write_pipe, 0, 500)) {
//             g_print("Host seems to be dead!\n");
//             exit(1);
//             }
        write(write_pipe, data_ptr, char_number);
	    }
        
 if (FAKE == board_type){
    fake_sendchararray(char_number, data_ptr);
    }
 
 return char_number; /* send char array to the board*/
}




